<?php session_start(); require_once 'config.php'; ?><!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Services - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link
        href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
    
    <?php include 'header.php'; ?>
    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
            <div class="container z-index-common">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">our <span>service</span></h1>
                </div>
                <div class="breadcumb-menu-wrap">
                    <ul class="breadcumb-menu">
                        <li><a href="index.php">Home</a></li>
                        <li>our service</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Service Area  -->
         <section class="vs-service__layout1 bg-linear space position-relative">
        <style>
            .vs-service__style1 {
    background: #fff;
    border-radius: 14px;
    overflow: hidden;
    height: 100%;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    transition: transform 0.3s ease;
    cursor: pointer;
}

.vs-service__style1:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 35px rgba(0,0,0,0.15);
}

.vs-service__img img {
    width: 100%;
    height: 220px;
    object-fit: cover;
}

.vs-service__body {
    padding: 20px;
    text-align: center;
}

.vs-service__subtitle {
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: #777;
}

.vs-service__title {
    font-size: 18px;
    font-weight: 600;
    margin: 8px 0;
}

.vs-service__text {
    font-size: 14px;
    color: #555;
    line-height: 1.6;
}

/* Tablet */
@media (max-width: 991px) {
    .vs-service__img img {
        height: 200px;
    }
}

/* Mobile */
@media (max-width: 576px) {
    .vs-service__img img {
        height: 180px;
    }

    .vs-service__title {
        font-size: 16px;
    }

    .vs-service__text {
        font-size: 13px;
    }
}

        </style>
            <div class="container">

        <!-- Section Title -->
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8">
                <div class="title-area text-center">
                    <span class="sec-subtitle">PROFESSIONAL CLEANING</span>
                    <h2 class="sec-title">Our Premium Services</h2>
                </div>
            </div>
        </div>

        <!-- Services Grid -->
        <div class="row g-4">
            <?php
            // Fetch services from database
            $query = "SELECT id, name, category, description, image, price FROM services WHERE status = 'active' ORDER BY id ASC";
            $result = $conn->query($query);
            
            // Fallback services if database is empty
            $fallback_services = array(
                array('id' => 1, 'name' => 'Home Cleaning', 'category' => 'Residential', 'description' => 'Complete cleaning for floors, furniture, and living spaces.', 'image' => 'assets/img/service/service-img-1-1.jpg', 'price' => '150'),
                array('id' => 2, 'name' => 'Kitchen Cleaning', 'category' => 'Deep Clean', 'description' => 'Grease-free kitchens with hygienic surface treatment.', 'image' => 'assets/img/service/service-img-1-2.jpg', 'price' => '100'),
                array('id' => 3, 'name' => 'Air Purification', 'category' => 'Health Care', 'description' => 'Improves indoor air quality by removing allergens and odors.', 'image' => 'assets/img/service/service-img-1-3.jpg', 'price' => '75'),
                array('id' => 4, 'name' => 'Bed & Mattress', 'category' => 'Sanitization', 'description' => 'Deep cleaning to remove dust mites, stains, and bacteria.', 'image' => 'assets/img/service/service-img-1-4.jpg', 'price' => '120'),
                array('id' => 5, 'name' => 'Office Cleaning', 'category' => 'Commercial', 'description' => 'Professional office cleaning for a productive workspace.', 'image' => 'assets/img/service/service-img-1-5.jpg', 'price' => '200')
            );
            
            // Use database results or fallback
            if ($result && $result->num_rows > 0) {
                $services = array();
                while ($row = $result->fetch_assoc()) {
                    $services[] = $row;
                }
            } else {
                $services = $fallback_services;
            }
            
            // Display services
            foreach ($services as $service):
            ?>
            <!-- Service -->
            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                <a href="service-details.php?id=<?php echo urlencode($service['id']); ?>" style="text-decoration: none; color: inherit;">
                    <div class="vs-service__style1">
                        <div class="vs-service__img">
                            <img src="<?php echo htmlspecialchars($service['image']); ?>" alt="<?php echo htmlspecialchars($service['name']); ?>">
                        </div>
                        <div class="vs-service__body">
                            <p class="vs-service__subtitle"><?php echo htmlspecialchars($service['category']); ?></p>
                            <h3 class="vs-service__title"><?php echo htmlspecialchars($service['name']); ?></h3>
                            <p class="vs-service__text">
                                <?php echo htmlspecialchars($service['description']); ?>
                            </p>
                            <?php if (isset($service['price'])): ?>
                            <p style="margin-top: 10px; font-weight: 600; color: #109c3d;">
                                $<?php echo htmlspecialchars($service['price']); ?>
                            </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

    <?php include 'footer.php'; ?>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>